﻿using System;
using System.Collections;
using System.Linq;
using System.Text;

namespace BlackJack
{
    class Deck
    {
        ArrayList cards = new ArrayList();

        public Deck()
        {
            char[] suits = {'s', 'c', 'd', 'h'};
            for (int i = 0; i < 52; i++)
            {
                int v = (i % 10) + 1;
                char s = suits[i / 13];
                cards.Add(new Card(v, s));
            }
        }

        public void shuffle()
        {
            Random rn = new Random();
            ArrayList temp = new ArrayList();
            foreach (Card c in cards)
            {
                int i = rn.Next(0, temp.Count);
                temp.Insert(i, c);
                temp.Reverse();
            }
            cards = temp;
            
        }

        public Card deal()
        {
            if (cards.Count > 0)
            {
                Card c = (Card)cards[0];
                cards.RemoveAt(0);
                return c;
            }
            else
            {
                System.Windows.Forms.MessageBox.Show("NO MOAR CARDS!!!");
                return null;
            }


        }

        override public String ToString()
        {
            String result = "";
            foreach (Card c in cards)
            {
                result += c.ToString();
                result += "\n";
            }
            return result;
        }
    }
}
