﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;


namespace BlackJack
{
    public partial class Game : Form
    {
        Deck d;
        Hand h;
        AI enemy, enemy2, enemy3;

        public Game()
        {
            InitializeComponent();
            d = new Deck();
            h = new Hand();
            enemy = new AI();
            enemy2 = new AI();
            enemy3 = new AI();
            er.Text = enemy.max.ToString();
            e2r.Text = enemy2.max.ToString();
            e3r.Text = enemy3.max.ToString();
            d.shuffle();
            h.acceptCard(d.deal());
            enemy.myh.acceptCard(d.deal());
            enemy2.myh.acceptCard(d.deal());
            enemy3.myh.acceptCard(d.deal());
            h.acceptCard(d.deal());
            enemy.myh.acceptCard(d.deal());
            enemy2.myh.acceptCard(d.deal());
            enemy3.myh.acceptCard(d.deal());
            refreshthis();
        }

        private void refreshthis()
        {
            handlabel.Text = h.ToString();
            aihandlabel.Text = enemy.ToString();
            aihandlabel2.Text = enemy2.ToString();
            aihandlabel3.Text = enemy2.ToString();
            //debug.Text = d.ToString();
            sumlabel.Text = h.sum.ToString();
        }

        private void shuffbutton_Click(object sender, EventArgs e)
        {
            d.shuffle();
            refreshthis();
        }

        private void dealbutton_Click(object sender, EventArgs e)
        {
            h.acceptCard(d.deal());
            if (enemy.hit())
            {
                enemy.myh.acceptCard(d.deal());
            }
            if (enemy2.hit())
            {
                enemy2.myh.acceptCard(d.deal());
            }
            if (enemy3.hit())
            {
                enemy3.myh.acceptCard(d.deal());
            }
            refreshthis();
            if (h.isBust())
            {
                esumlabel.Text = enemy.myh.sum.ToString();
                esumlabel2.Text = enemy2.myh.sum.ToString();
                esumlabel3.Text = enemy3.myh.sum.ToString();
                lose();
            }
        }

        private void lose()
        {
            MessageBox.Show("You lost...", "Oh teh noes.");
            switch (MessageBox.Show("Do you want to play again?",
                    "pretty pleeease?",
                    MessageBoxButtons.YesNoCancel,
                    MessageBoxIcon.Question))
            {
                case DialogResult.Yes:
                    Application.Restart();
                    break;

                case DialogResult.No:
                    Application.Exit();
                    break;

                case DialogResult.Cancel:
                    Application.Exit();
                    break;
            }
        }

        private void win()
        {
            MessageBox.Show("You won!", "most excellent.");
            switch (MessageBox.Show("Do you want to play again?",
                    "or, you could just quit while you are ahead...",
                    MessageBoxButtons.YesNoCancel,
                    MessageBoxIcon.Question))
            {
                case DialogResult.Yes:
                    Application.Restart();
                    break;

                case DialogResult.No:
                    Application.Exit();
                    break;

                case DialogResult.Cancel:
                    Application.Exit();
                    break;
            }
        }

        private void holdbutton_Click(object sender, EventArgs e)
        {
            while (enemy.hit())
            {
                enemy.myh.acceptCard(d.deal());
                refreshthis();
            }
            while (enemy2.hit())
            {
                enemy2.myh.acceptCard(d.deal());
                refreshthis();
            }
            while (enemy3.hit())
            {
                enemy3.myh.acceptCard(d.deal());
                refreshthis();
            }
            esumlabel.Text = enemy.myh.sum.ToString();
            esumlabel2.Text = enemy2.myh.sum.ToString();
            esumlabel3.Text = enemy3.myh.sum.ToString();
            int wins = 0;
            if (enemy.myh.isBust())
            {
                wins++;
            }
            else if (h.sum >= enemy.myh.sum)
            {
                wins++;
            }
            if (enemy2.myh.isBust())
            {
                wins++;
            }
            else if (h.sum >= enemy2.myh.sum)
            {
                wins++;
            }
            if (enemy3.myh.isBust())
            {
                wins++;
            }
            else if (h.sum >= enemy3.myh.sum)
            {
                wins++;
            }
            if (wins == 3)
            {
                win();
            }
            else
            {
                lose();
            }

            

        }

    }

}
