<?php
/**
	MercyComic Engine
	~ Will Carter (http://www.will-carter.com)


	MercyViewer
		this package displays the comic, title, text, and navigation buttons.


	USAGE:

		Simply include this file (like this:)
			<?php include 'mercyviewer.php';?>
		on the page you want to display the comics on.

		Comics, text, and titles are stored in individual files, in the $data directory.
		For instance, for the 25th comic, the files are:
			0025.png (the comic image)
			0025.title (a text file, with the title of the comic on the first line)
			0025.text (a text file containing comments about the comic.

		There is one additional data file to worry about (stored in the same directory as this page): 
			last.comic (a text file, containing the four digit number of the latest comic)

		You can either create and place these files by hand, or use the associated
		MercyUploader comic upload page. Either way works.

		There are also navigation buttons, which you should customize:
			first.png	(first comic)
			prev.png	(previous comic)
			noprev.png	(no previous comic exists)
			next.png	(next comic)
			nonext.png	(no next comic exists)
			last.png	(last comic)

		Oh, and BE SURE TO SET THE VARIABLES BELOW THIS COMMENT.
	
		Enjoy!
*/

//set this variable to the base directory of your comic site, INCLUDE TRAILING SLASH
//for instance, http://www.mywebsite.com/, http://comic.mywebsite.com/, etc.
//this url SHOULD point to a page that includes this script.
$url = "http://www.yourcomicsite.com/";

//set this variable to the image format of your comics (.png, .jpg, etc)
$cext = ".png";

//set this variable to the data directory for your comics.
//this will be where the comic images, titles, and text are stored.
//for instance, if the files are stored in http://www.mywebsite.com/comicdata/,
//use "comicdata/".
$data = "comicdata/";




//
//
//
//
//
//BEGIN MERCYVIEWER CODE BELOW:
//(no need to modify.)
//(unless you want to.)
//
//
//
//


//figure out which comic number they want to see - set to $comicnum
$comicnum = $_GET['id'];

//if there isn't one, we're at the main page!
if ($_GET['id'] == null){
	//open the last.comic file, read the most recent comic number to $comicnum
	$lcnf = "last.comic";
	$lcn = fopen($lcnf, 'r');
	$comicnum = fread($lcn, 4);
	fclose($lcn);
	}

//make sure they didn't try to use a bad url
if (is_numeric($comicnum))
	{
		//get urls for the comic image, title, and text files.
		$curl = "{$data}"."{$comicnum}"."{$cext}";
		$cturl = "{$data}"."{$comicnum}".".title";
		$ccurl = "{$data}"."{$comicnum}".".text";
		
		//if there is a title, set it to $title
		if(@file_get_contents($cturl)){
			$ct = fopen($cturl, 'r');
			$title = fgets($ct);
			fclose($ct);
		}
		else {
			//otherwise, leave blank
			$title = "";		
		}

		//if there is comment text, set it to $text
		if(@file_get_contents($ccurl)){
			$text = file_get_contents($ccurl);
		}
		else {
			//otherwise, leave blank
			$text = "";
		}
		
		//check to see if that comic exists
		if(@file_get_contents($curl)){
			//if it does, display it, with the title and number at top.
			echo "<h2>#" . $comicnum . " - " . $title . "</h2>";
			echo "<img src='$curl' alt='Comic number $comicnum - $title' 
				title='Comic number $comicnum - $title' />
				";			
			$cnp = $comicnum - 1;
			$cnp = str_pad($cnp, 4, "0", STR_PAD_LEFT);
			$cnn = $comicnum + 1;
			$cnn = str_pad($cnn, 4, "0", STR_PAD_LEFT);

		
		}	
		else{
			//otherwise, send them back to the main page.
			header( 'Location: '.$url) ;
			echo "Sorry? Your URL (" . $comicnum . ") doesn't exist yet...";
			echo '<script type="text/javascript">';
		        echo 'window.location.href="'.$url.'";';
		        echo '</script>';
		        echo '<noscript>';
		        echo '<meta http-equiv="refresh" content="0;url='.$url.'" />';
		        echo '</noscript>'; exit;		
		}

			//display the comic comment text.
			echo "<div id='text'>" . $text . "</div>";

			echo "<div id='navbox'>";	

			//create the urls for the previous and next comic
			$curlp = "{$data}"."{$cnp}"."{$cext}";
			$curln = "{$data}"."{$cnn}"."{$cext}";	

			//display a button link to the first comic
			echo "<a href='".$url."?id=0000'><img src='first.png' border=0 
				alt='First Comic' title='First Comic' /></a>";

			//if there is a previous comic, link to it
			if(@file_get_contents($curlp)){
				echo "<a href='".$url."?id=".
					"{$cnp}"."'><img src='prev.png' border=0 alt='Previous Comic' 
					title='Previous Comic'/></a>";
			}
			else {
				//otherwise, show a greyed-out/inaccesable button
				echo "<img src='noprev.png' alt='No Previous Comic!' title='No Previous Comic!'
					 />";
			}
			
			//if there is a next comic, link to it
			if(@file_get_contents($curln)){
				echo "<a href='".$url."?id=".
					"{$cnn}"."'><img src='next.png' border=0 alt='Next Comic' 
					title='Next Comic' /></a>";
			}
			else {
				//otherwise, show a greyed-out/inaccesable button
				echo "<img src='nonext.png' alt='No Next Comic!' title='No Next Comic!'
					 />";
			}
			
			//show a button linking to most recent comic (main page.)
			echo "<a href='".$url."'><img src='last.png' border=0
				alt='Latest Comic' title='Latest Comic' /></a>";

			echo "</div>";

			

	}

else {
	//if they gave us a bad url, send them back to the main page.
	header( 'Location: '.$url ) ;
	echo "Sorry? Your URL (" . $comicnum . ") didn't specify a comic...";
	
	echo '<script type="text/javascript">';
        echo 'window.location.href="'.$url.'";';
        echo '</script>';
        echo '<noscript>';
        echo '<meta http-equiv="refresh" content="0;url='.$url.'" />';
        echo '</noscript>'; exit;

}

?>
