# This library contains functions and variables relating to characters.
# Such as creating them. And naming them. And printing them. And stuff.

import random, ItemLib, easygui


# These store the text values of teh races and classes.
racename = {0: "elf", 1: "human", 2: "dwarf"}
classname = {0: "mage", 1: "warrior"}
revracename = {"elf": 0, "human": 1, "dwarf": 2}
revclassname = {"mage": 0, "warrior": 1}

# This gets the user's name, race, and class.
def GetUserInfo():
    eggs = ["","",""]
    eggs[0] = easygui.enterbox("Enter your character name:", "Boring Paperwork")
    eggs[1] = easygui.choicebox("Select your race:", "Boring Paperwork", ["elf", "human", "dwarf"])
    eggs[2] = easygui.choicebox("Select your class:", "Boring Paperwork", ["mage", "warrior"])
    print "char info: "
    print eggs
    return eggs

# This makes a new character with user-defined name, race, and class.
def UserCharacter():
    args = GetUserInfo()
    charname = args[0]
    race = revracename[args[1]]
    classnum = revclassname[args[2]]
    hp = random.randint(25,35) + (2*(race)) 
    defense = random.randint(2,4) + race + (2*(classnum))
    str = random.randint(3,7) + (2*(race)) + (2*(classnum))
    mag = random.randint(2,3) + (2*(3 - race)) + (2 - classnum)  
    magdef = 1 + (2 - race) 
    race = racename[race]
    classnum = classname[classnum]
    mystats = [charname, race, classnum, hp, defense, str, mag, magdef, 0, 0, hp, "fist", 25, 0]
    print "char stats: "
    print mystats
    return mystats


# This makes a new, completely random, character. 
# Stats list = (name, race, class, hp, def, str, mag, magdef, lvl, exp, temphp, weapon, gold, weapbonus)
def RandCharacter(me):
    charname = makename()
    bonus = (me[8] / 2) + 1
    race = random.randint(0,2)
    classnum = random.randint(0,1)
    hp = random.randint(20,38) + (2*(race)) + bonus
    defense = random.randint(1,5) + race + (2*(classnum)) + bonus
    str = random.randint(2,7) + race + (2*(classnum)) + bonus
    mag = random.randint(1,3) + (2*(3 - race)) + (2 - classnum) + bonus  
    magdef = random.randint(0,1) + (2 - race) + bonus
    race = racename[race]
    classnum = classname[classnum]
    weapon = ItemLib.WeaponName()
    gold = random.randint(10,25)
    level = (me[8] - 1) + random.randint(-2,2)
    if (level <= 0):
        level = 0
    return [charname, race, classnum, hp, defense, str, mag, magdef, level, 0, hp, weapon, gold, 0]
    

   
    
# Stats list = (name, race, class, hp, def, str, mag, magdef, lvl, exp, temphp, weapon, gold, weapbonus)
def PrintStats(args):

    print "Name:", args[0]
    print args[1], args[2]
    print "Health:", args[10], "/", args[3]
    print "Defense:", args[4]
    print "Strength:", args[5]
    print "Magic:", args[6]
    print "Magic Defense:", args[7]
    print "Level:", args[8]
    print "Experience:", args[9]
    print "Weapon:", args[11]
    if args[13] > 0:
        print "Weapon Bonus:", args[13]
    print "Gold:", args[12]
    
    text = "Name: " + args[0]     
    text += "\n" + args[1] + " " + args[2]
    text += "\n" + "Health: " + str(args[10]) + "/" + str(args[3])
    text += "\n" + "Defense: " + str(args[4])
    text += "\n" + "Strength: " + str(args[5])
    text += "\n" + "Magic: " + str(args[6])
    text += "\n" + "Magic Defense: " + str(args[7])
    text += "\n" + "Level: " + str(args[8])
    text += "\n" + "Experience: " + str(args[9])
    text += "\n" + "Weapon: " + str(args[11])
    if (args[13] > 0):
        text += "\n" + "Weapon Bonus: " + str(args[13])
    text += "\n" + "Gold: " + str(args[12])
    message = args[0] + "'s stats:"
    easygui.textbox(message, "Get out your slide rule...", text, 0)

def PrintDualStats(args, enemy):    
    text = "Name: \t\t" + args[0] + "\t\t" + enemy[0]     
    text += "\n\t\t" + args[1] + " " + args[2] + "\t\t" + enemy[1] + " " + enemy[2]
    text += "\n" + "Health:\t\t" + str(args[10]) + "/" + str(args[3]) + "\t\t" + str(enemy[10]) + "/" + str(enemy[3])
    text += "\n" + "Defense:\t\t" + str(args[4]) + "\t\t" + str(enemy[4])
    text += "\n" + "Strength:\t\t" + str(args[5]) + "\t\t" + str(enemy[5])
    text += "\n" + "Magic:\t\t" + str(args[6]) + "\t\t" + str(enemy[6])
    text += "\n" + "Magic Defense:\t" + str(args[7]) + "\t\t" + str(enemy[7])
    text += "\n" + "Level:\t\t" + str(args[8]) + "\t\t" + str(enemy[8])
    text += "\n" + "Experience:\t" + str(args[9]) + "\t\t" + str(enemy[9])
    text += "\n" + "Weapon:\t\t" + args[11] + "\t\t" + enemy[11]
    if (args[13] > 0):
        text += "\n" + "Weapon Bonus:\t" + str(args[13])
    text += "\n" + "Gold:\t\t" + str(args[12]) + "\t\t" + str(enemy[12])
    message = "Combatants' stats:"
    easygui.textbox(message, "Get out your slide rule...", text, 0)
            
# This levels up a character, which means their stats increase slightly.
def LevelUp(args):
    if (args[9] >= 100):
        message = args[0] + " leveled up!"
        print "w00t... level up."
        easygui.msgbox(message, "teh w00t!", "yay")
        args[3] += random.randint(0,3)
        for i in range(4,7):
            args[i] += random.randint(0,2) 
        args[8] += 1
        args[9] -= 100
        args[10] = args[3]
    return args            
            
            
# This randomly generates a name, using the RabidCentipede NAME GENERATOR!!!!
# (optional title), (variable amount of consonant, vowel, consonant) or (consonant, vowel, vowel), (optional epithet)
# The names should be somewhat pronounciable!           
def makename():
    name = titles[random.randint(0,7)]
    for i in range(0,random.randint(2,3)):
        if (random.randint(1,2) == 1):
            name = name + consonants[random.randint(0,21)]
            name = name + vowels[random.randint(0,5)]
            name = name + consonants[random.randint(0,21)]
        else:
            name = name + consonants[random.randint(0,21)]
            name = name + vowels[random.randint(0,5)]
            name = name + vowels[random.randint(0,5)]
    name = name + epithets[random.randint(0,7)]
    return name
             
            
# These store name parts
titles = "noble ", "", "valiant ", "", "sir ", "", "lady ", ""
consonants = "b", "c", "d", "f", "g", "h", "j", "k", "l", "m", "n", "p", "q", "r", "s", "t", "v", "w", "x", "z", "", ""
vowels = "a", "e", "i", "o", "u", "y"  
epithets = " the great", "", " the magnificant", "", " the brave", "", " the wise", "" 


